#include	"PCA.h"

bit		B_Capture0,B_Capture1,B_Capture2;
u8		PCA0_mode,PCA1_mode,PCA2_mode;
u16		CCAP0_tmp,PCA_Timer0;
u16		CCAP1_tmp,PCA_Timer1;
u16		CCAP2_tmp,PCA_Timer2;

/*************	˵	**************


******************************************/

u16	PWM0_low;	//PWM͵ƽPCAʱ, û㲻ɼ
u16	PWM1_low;	//PWM͵ƽPCAʱ, û㲻ɼ
u16	PWM2_low;	//PWM͵ƽPCAʱ, û㲻ɼ


//========================================================================
// : void PWMn_Update(u8 PCA_id, u16 high)
// : ռձݡ
// : high: 	ռձݣPWMߵƽPCAʱ
// : 
// 汾: VER1.0
// : 2013-5-15
// ע: 
//========================================================================
void PWMn_Update(u8 PCA_id, u16 high)
{
	if(PCA_id == PCA0)
	{
		if(high > PWM_HIGH_MAX_PCA)	high = PWM_HIGH_MAX_PCA;	//дռձݣǿΪռձȡ
		if(high < PWM_HIGH_MIN_PCA)	high = PWM_HIGH_MIN_PCA;	//дССռձݣǿΪСռձȡ
		CR = 0;							//ֹͣPCA
		PCA_Timer0 = high;				//ȷΧװռձȼĴ
		PWM0_low = PWM_DUTY_PCA - high;	//㲢PWM͵ƽPCAʱ
		CR = 1;							//PCA
	}
	else if(PCA_id == PCA1)
	{
		if(high > PWM_HIGH_MAX_PCA)	high = PWM_HIGH_MAX_PCA;	//дռձݣǿΪռձȡ
		if(high < PWM_HIGH_MIN_PCA)	high = PWM_HIGH_MIN_PCA;	//дССռձݣǿΪСռձȡ
		CR = 0;							//ֹͣPCA
		PCA_Timer1 = high;				//ȷΧװռձȼĴ
		PWM1_low = PWM_DUTY_PCA - high;	//㲢PWM͵ƽPCAʱ
		CR = 1;							//PCA
	}
	else if(PCA_id == PCA2)
	{
		if(high > PWM_HIGH_MAX_PCA)		high = PWM_HIGH_MAX_PCA;	//дռձݣǿΪռձȡ
		if(high < PWM_HIGH_MIN_PCA)		high = PWM_HIGH_MIN_PCA;	//дССռձݣǿΪСռձȡ
		CR = 0;							//ֹͣPCA
		PCA_Timer2 = high;				//ȷΧװռձȼĴ
		PWM2_low = PWM_DUTY_PCA - high;	//㲢PWM͵ƽPCAʱ
		CR = 1;							//PCA
	}
}



//========================================================================
// : void UpdatePwm(u8 PCA_id, u8 pwm_value)
// : PWMֵ. 
// : PCA_id: PCA. ȡֵ PCA0,PCA1,PCA2,PCA_Counter
//		 pwm_value: pwmֵ, ֵ͵ƽʱ.
// : none.
// 汾: V1.0, 2012-11-22
//========================================================================


//========================================================================
// : void	PCA_Init(PCA_id, PCA_InitTypeDef *PCAx)
// : PCAʼ.
// : PCA_id: PCA. ȡֵ PCA0,PCA1,PCA2,PCA_Counter
//		 PCAx: ṹ,οPCA.hĶ.
// : none.
// 汾: V1.0, 2012-11-22
//========================================================================
void	PCA_Init(u8 PCA_id, PCA_InitTypeDef *PCAx)
{
	if(PCA_id > PCA_Counter)	return;		//id

	if(PCA_id == PCA_Counter)			//ùCounter
	{
		CR = 0;
		CH = 0;
		CL = 0;
		AUXR1 = (AUXR1 & ~(3<<4)) | PCAx->PCA_IoUse;			//лIO
		CMOD  = (CMOD  & ~(7<<1)) | PCAx->PCA_Clock;			//ѡʱԴ
		CMOD  = (CMOD  & ~1) | (PCAx->PCA_Interrupt_Mode & 1);	//ECF
		if(PCAx->PCA_Polity == PolityHigh)		PPCA = 1;	//ȼж
		else									PPCA = 0;	//ȼж
		if(PCAx->PCA_RUN == ENABLE)	CR = 1;
		return;
	}

	PCAx->PCA_Interrupt_Mode &= (3<<4) + 1;
	if(PCAx->PCA_Mode >= PCA_Mode_SoftTimer)	PCAx->PCA_Interrupt_Mode &= ~(3<<4);

	if(PCA_id == PCA0)
	{
		CCAPM0    = PCAx->PCA_Mode | PCAx->PCA_Interrupt_Mode;	//ģʽ, жģʽ
		PCA_PWM0  = (PCA_PWM0 & ~(3<<6)) | PCAx->PCA_PWM_Wide;	//PWM

		PCA_Timer0 = PCAx->PCA_Value;
		B_Capture0 = 0;
		PCA0_mode = PCAx->PCA_Mode;
		CCAP0_tmp = PCA_Timer0;
		CCAP0L = (u8)CCAP0_tmp;			//ӰĴд벶ĴдCCAP0L
		CCAP0H = (u8)(CCAP0_tmp >> 8);	//дCCAP0H
	}
	if(PCA_id == PCA1)
	{
		CCAPM1    = PCAx->PCA_Mode | PCAx->PCA_Interrupt_Mode;
		PCA_PWM1  = (PCA_PWM1 & ~(3<<6)) | PCAx->PCA_PWM_Wide;

		PCA_Timer1 = PCAx->PCA_Value;
		B_Capture1 = 0;
		PCA1_mode = PCAx->PCA_Mode;
		CCAP1_tmp = PCA_Timer1;
		CCAP1L = (u8)CCAP1_tmp;			//ӰĴд벶ĴдCCAP0L
		CCAP1H = (u8)(CCAP1_tmp >> 8);	//дCCAP0H
	}
	if(PCA_id == PCA2)
	{
		CCAPM2    = PCAx->PCA_Mode | PCAx->PCA_Interrupt_Mode;
		PCA_PWM2  = (PCA_PWM2 & ~(3<<6)) | PCAx->PCA_PWM_Wide;

		PCA_Timer2 = PCAx->PCA_Value;
		B_Capture2 = 0;
		PCA2_mode = PCAx->PCA_Mode;
		CCAP2_tmp = PCA_Timer2;
		CCAP2L = (u8)CCAP2_tmp;			//ӰĴд벶ĴдCCAP0L
		CCAP2H = (u8)(CCAP2_tmp >> 8);	//дCCAP0H
	}
}


//========================================================================
// : void	PCA_Handler (void) interrupt PCA_VECTOR
// : PCAжϴ.
// : None
// : none.
// 汾: V1.0, 2012-11-22
//========================================================================
void	PCA_Handler (void) interrupt PCA_VECTOR
{
	if(CCF0)		//PCAģ0ж
	{
		CCF0 = 0;		//PCAģ0жϱ־
		if(P25)	CCAP0_tmp += PCA_Timer0;	//ΪߵƽӰĴװظߵƽʱ䳤
		else	CCAP0_tmp += PWM0_low;	//Ϊ͵ƽӰĴװص͵ƽʱ䳤
		CCAP0L = (u8)CCAP0_tmp;			//ӰĴд벶ĴдCCAP0L
		CCAP0H = (u8)(CCAP0_tmp >> 8);	//дCCAP0H
	}

	if(CCF1)	//PCAģ1ж
	{
		CCF1 = 0;		//PCAģ1жϱ־
		if(P26)	CCAP1_tmp += PCA_Timer1;	//ΪߵƽӰĴװظߵƽʱ䳤
		else	CCAP1_tmp += PWM1_low;	//Ϊ͵ƽӰĴװص͵ƽʱ䳤
		CCAP1L = (u8)CCAP1_tmp;			//ӰĴд벶ĴдCCAP0L
		CCAP1H = (u8)(CCAP1_tmp >> 8);	//дCCAP0H
	}

	if(CCF2)	//PCAģ2ж
	{
		CCF2 = 0;		//PCAģ1жϱ־
		if(P27)	CCAP2_tmp += PCA_Timer2;	//ΪߵƽӰĴװظߵƽʱ䳤
		else	CCAP2_tmp += PWM2_low;	//Ϊ͵ƽӰĴװص͵ƽʱ䳤
		CCAP2L = (u8)CCAP2_tmp;			//ӰĴд벶ĴдCCAP0L
		CCAP2H = (u8)(CCAP2_tmp >> 8);	//дCCAP0H
	}

/*	if(CF)	//PCAж
	{
		CF = 0;			//PCAжϱ־
	}
*/
}